#include ".\pingsink.h"
#include <comutil.h>
#include <iostream>

CPingSink :: CPingSink( void ) : m_inProgress( true ), m_isReachable( false ), mp_lCount( 0 )
{
}

CPingSink :: ~CPingSink( void )
{
}

HRESULT STDMETHODCALLTYPE
CPingSink :: QueryInterface( REFIID riid, void __RPC_FAR * __RPC_FAR *ppvObject )
{
	if ( ( riid == IID_IUnknown ) || ( riid == IID_IWbemObjectSink ) )
	{
		*ppvObject = this;
		AddRef();
		return S_OK;
	}
	else 
	{
		*ppvObject = NULL;
		return E_NOINTERFACE;
	}
}

ULONG STDMETHODCALLTYPE
CPingSink :: AddRef( void )
{
	return InterlockedIncrement( &mp_lCount );
}

ULONG STDMETHODCALLTYPE
CPingSink :: Release( void )
{
	if ( mp_lCount == 0 )
	{
		delete this;
		return 0;
	}
	else return InterlockedDecrement( &mp_lCount );
}

HRESULT STDMETHODCALLTYPE
CPingSink :: Indicate( long lObjectCount, IWbemClassObject** apObjArray )
{
	// we assume only one addess to be ping'ed here. Must be changed to reflect multiple
	// addresses
	if ( lObjectCount > 0 )
	{
		// get the result from resulting IWbemClassObject instances and process them
		// in this case, this means store them in the sink instance
		_variant_t result;
		HRESULT hr = apObjArray[ 0 ]->Get( L"StatusCode", 0, &result, NULL, NULL );
		if ( SUCCEEDED( hr ) )
		{
			int status = result;
			m_isReachable = ( status == 0 );
		}
	}

	return WBEM_S_NO_ERROR;
}

HRESULT STDMETHODCALLTYPE
CPingSink :: SetStatus( long lFlags, HRESULT hResult, BSTR strParam, IWbemClassObject* pObjectParam )
{
	// trivial implementation; without WBEM_FLAG_SEND_STATUS this method is called exactly once - on query completion
	m_inProgress = false;
	return WBEM_S_NO_ERROR;
}
